<?xml version="1.0" encoding="UTF-8"?>
<schema xmlns="http://purl.oclc.org/dsdl/schematron" queryBinding="xslt2">
    <title>Schematronvalidatie van MFMT_IN002310NL - Reject Act Reference Request</title>
    <ns uri="urn:hl7-org:v3" prefix="hl7"/>
    <ns uri="http://www.w3.org/2001/XMLSchema-instance" prefix="xsi"/>

    <include href="coreschematron/xml.sch"/>
    <include href="coreschematron/attentionLine.sch"/>
    
    <include href="coreschematron/transmission-wrapper.sch"/>
    <include href="coreschematron/controlAct-wrapper.sch"/>
    
    <include href="VWI/MFMT_MT902001NL.sch"/>

    <!--pattern is-a="attentionLine" id="MFMT_IN002310NL-attentionLine">
        <param name="messagePatientId" value="hl7:ControlActProcess/hl7:subject/hl7:registrationProcess/hl7:subject2/hl7:ActReference/hl7:recordTarget/hl7:patient/hl7:id"/>
        <param name="attentionLineOptional" value="'false'"/>
        </pattern-->
    
    <pattern is-a="transmission-wrapper" id="MFMT_IN002310NL-wrapper">
        <param name="element" value="hl7:MFMT_IN002310NL"/>
    </pattern>
    
    <pattern is-a="controlAct-wrapper" id="MFMT_IN002310NL-controlAct">
        <param name="element" value="hl7:MFMT_IN002310NL/hl7:ControlActProcess"/>
    </pattern>
    
    <pattern>
        <!-- profileId -->
        <rule context="hl7:MFMT_IN002310NL/hl7:profileId">
            <extends rule="II"/>
            <assert role="error" test="@root='2.16.840.1.113883.2.4.3.11.1' and @extension='810'"
                >In de transmission wrapper moet het element profileId worden gevuld met de waarde '810'</assert>
        </rule>
        <rule context="hl7:MFMT_IN002310NL/hl7:acceptAckCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='NE'">In de transmission wrapper moet het veld acceptAckCode worden gevuld met waarde 'NE'.</assert>
        </rule>
        <rule context="hl7:MFMT_IN002310NL/hl7:attentionLine">
            <assert role="warning" test="not(.)">Het gebruik van attentionLine wordt nog niet gespecificeerd in deze interactie.</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>Zender en ontvanger</title>
        <rule context="hl7:MFMT_IN002310NL/hl7:sender/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and @extension='1'"
                >De zender van deze interactie moet de ZIM zijn</assert>
        </rule>
        <rule context="hl7:MFMT_IN002310NL/hl7:receiver/hl7:device/hl7:id">
            <assert role="error" test="@root='2.16.840.1.113883.2.4.6.6' and not(@extension='1')"
                >De ontvanger van deze interactie moet een AORTA applicatie zijn, en kan niet de ZIM zijn</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>error indication</title>
        <rule context="hl7:MFMT_IN002310NL">
            <assert role="error" test="hl7:acknowledgement/hl7:acknowledgementDetail/hl7:code[not(@nullFlavor)] or
                hl7:ControlActProcess/hl7:reason/hl7:justifyingDetectedIssueEvent/hl7:code[not(@nullFlavor)]"
                >Een afwijzing moet een syntactische of inhoudelijke reden hebben waarom</assert>
        </rule>
    </pattern>
    
    <pattern>
        <title>acknowledgementType</title>
        <rule context="hl7:MFMT_IN002310NL/hl7:acknowledgement">
            <assert role="error" test="@typeCode='AE' or @typeCode='AR'"
                >acknowledgement/@typeCode moet bij een afwijzende interactie 'AE' of 'AR' zijn</assert>
        </rule>
    </pattern>
     
    <pattern>
        <title>registrationProcess</title>
        <rule context="hl7:subject/hl7:registrationProcess">
            <assert role="error" test="not(@moodCode) or @moodCode='RQO'" see="http://www.hl7.org/v3ballot/html/infrastructure/vocabulary/ActMood.htm#RQO"
                >registrationProcess/@moodCode moet 'RQO' zijn</assert>
            <assert role="error" test="count(hl7:subject2)=1"
                >registrationProcess/subject2 moet exact één maal voorkomen. Registraties van meer dan één Act zijn niet toegestaan</assert>
            <assert role="error" test="not(hl7:subject1)"
                >registrationProcess/subject1 is niet toegestaan in de Verwijsindex</assert>
        </rule>
        
        <title>registrationProcess/id</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:id">
            <extends rule="II"/>
            <assert role="error" test="not(.)"
                >registrationProcess/id mag niet worden gebruikt in berichten naar de Verwijsindex</assert>
        </rule>
        
        <title>registrationProcess/statusCode</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:statusCode">
            <extends rule="CS"/>
            <assert role="error" test="@code='active' or @code='nullified'"
                >registrationProcess/statuscode/@code moet 'active' of 'nullified' zijn.</assert>
        </rule>
        
        <title>registrationProcess/effectiveTime</title>
        <rule context="hl7:subject/hl7:registrationProcess/hl7:effectiveTime">
            <extends rule="IVL_TS"/>
            <assert role="error" test="@nullFlavor='UNK'"
                >registrationProcess/effectiveTime/@nullFlavor moet 'UNK' zijn in berichten naar de Verwijsindex</assert>
        </rule>
    </pattern>
    
    <pattern is-a="MFMT_MT902001NL" id="MFMT_IN002310NL-MFMT_MT902001NL">
        <param name="element" value="hl7:ActReference"/>
    </pattern>
</schema>
